
const dotenv = require('dotenv'); 
dotenv.config();
const mysql = require('mysql2'); 
const connect = mysql.createConnection({
  host: process.env.DB_HOST,  // Use environment variables for sensitive data
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
});

// Connect to the database
connect.connect((err) => {
  if (err) {
    console.error('Database connection failed: ', err.stack);
    return;
  }
  console.log('Connected to the database');
});

// Export the connection to use in other files
module.exports = connect;
