// index.js
const express = require('express');
const cors = require('cors');
const app = express();
const PORT = process.env.PORT || 3000;
app.use(cors());


const fleetRoute = require('./routes/fleet');
const booking = require('./routes/bookings')


app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use('/fleet', fleetRoute);
app.use('/bookings', booking);


// Default route
app.get('/', (req, res) => {
  res.send('Fleet scraper API is running');
});

// Start server
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});
