// routes/airports.js
const express = require("express");
const fs = require("fs");
const axios = require("axios");
const Papa = require("papaparse");
const path = require("path");

const router = express.Router();

// Dataset info
const datasetOwner = "aravindram11";
const datasetName = "list-of-us-airports";
const fileName = "airports.csv"; // Example CSV file inside the dataset
const downloadPath = path.join(__dirname, fileName);

// Function to download dataset file from Kaggle
async function downloadDataset() {
  try {
    const url = `https://www.kaggle.com/datasets/${datasetOwner}/${datasetName}/download/${fileName}`;
    
    const response = await axios({
      url,
      method: "GET",
      responseType: "stream",
    });

    const writer = fs.createWriteStream(downloadPath);
    response.data.pipe(writer);

    return new Promise((resolve, reject) => {
      writer.on("finish", resolve);
      writer.on("error", reject);
    });
  } catch (error) {
    console.error("Download error:", error.message);
    throw error;
  }
}

// Function to read CSV into JS
function loadCSV(filePath) {
  const csvFile = fs.readFileSync(filePath, "utf8");
  const results = Papa.parse(csvFile, { header: true });
  return results.data;
}

// Route to get airports
router.get("/", async (req, res) => {
  try {
    // Download dataset (optional if already downloaded)
    if (!fs.existsSync(downloadPath)) {
      await downloadDataset();
    }

    // Load CSV
    const data = loadCSV(downloadPath);
    res.json(data); // Return JSON to client
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

module.exports = router; // ✅ Export router
