const express = require('express');
const router = express.Router();
const db = require('../db/db.js'); // Your MySQL connection

// POST route → Insert new booking
router.post('/create', async (req, res) => {
  try {
    const {
      triptype,
      duration,
      ordertype,
      pickupdatetime,
      pickupaddress,
      pickupairline,
      pickupflight,
      dropaddress,
      dropairline,
      dropflight,
      passengers,
      dropupdatetime,
      returnpickupaddress,
      returnpickupairline,
      returnpickupflight,
      returndropaddress,
      returndropairline,
      returndropflight,
      vehiclename,
      firstName,
      lastName,
      email,
      phone
    } = req.body;

    // Validate required fields
    // if (!triptype || !duration || !ordertype || !pickupdatetime || !pickupaddress || !dropaddress || !passengers) {
    //   return res.status(400).json({
    //     ResponseCode: "400",
    //     Result: "false",
    //     ResponseMsg: "Missing required fields."
    //   });
    // }

    // Insert query
    const [result] = await db.promise().query(
      `INSERT INTO bookings 
      (triptype, duration, ordertype, pickupdatetime, pickupaddress, pickupairline, pickupflight, dropaddress, dropairline, dropflight, passengers, dropupdatetime, returnpickupLocation, returnpickupairline, returnpickupflight,  returndropaddress,  returndropairline, returndropflight, vehiclename, firstname, lastname, email, phone) 
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        triptype,
        duration,
        ordertype,
        pickupdatetime,
        pickupaddress,
        pickupairline || null,
        pickupflight || null,
        dropaddress,
        dropairline || null,
        dropflight || null,
        passengers,
        dropupdatetime || "",
        returnpickupaddress || "",
        returnpickupairline || "",
        returnpickupflight || "",
        returndropaddress || "",
        returndropairline || "",
        returndropflight || "",
        vehiclename || "",
           firstName || "",
              lastName || "",
                 email || "",
                    phone || "",
      ]
    );

    return res.status(200).json({
      ResponseCode: "200",
      Result: "true",
      ResponseMsg: "Booking added successfully.",
      Data: { bookingId: result.insertId }
    });

  } catch (error) {
    console.error('Database error:', error);
    return res.status(500).json({
      ResponseCode: "500",
      Result: "false",
      ResponseMsg: "Error adding booking."
    });
  }
});

module.exports = router;
