// routes/fleet.js
const express = require('express');
const router = express.Router();
const axios = require('axios');
const cheerio = require('cheerio');

// Function to scrape fleet data
async function scrapeFleetData() {
  try {
    const { data: html } = await axios.get('https://funtashtechnologies.com/nashlux/fleet-grid/');
    const $ = cheerio.load(html);

    const fleetItems = [];

    $('.pxl-grid-item').each((i, el) => {
      const title = $(el).find('.pxl-post--title a').text().trim();
      const img = $(el).find('.pxl-post--featured img').attr('src');
      const link = $(el).find('.pxl-post--title a').attr('href'); // optional vehicle link

      if (title && img) {
        fleetItems.push({ title, img, link });
      }
    });

    return fleetItems;

  } catch (err) {
    console.error('Error scraping fleet data:', err);
    return [];
  }
}

// Define route
router.get('/', async (req, res) => {
  const data = await scrapeFleetData();
  res.json(data);
});

module.exports = router;
