const axios = require('axios');
const cheerio = require('cheerio');

async function fetchFleetHTML() {
  try {
    // Fetch the HTML
    const { data: html } = await axios.get('https://funtashtechnologies.com/nashlux/fleet-grid/');
    
    // Load into Cheerio
    const $ = cheerio.load(html);

    // Get the HTML of the grid container
    const gridHTML = $('.pxl-grid-inner.pxl-grid-masonry.row').html();

    console.log(gridHTML); // logs all inner HTML of the container
    return gridHTML;

  } catch (err) {
    console.error('Error fetching fleet HTML:', err);
  }
}

// Example usage
fetchFleetHTML();
